<?php defined('SYSPATH') or die('No direct script access.');

class Task_Api_Server extends Minion_Task {
    private $transport = 'sslv3';
    private $port = '9908';

    protected function _execute(array $params){
        $ip = Kohana::$config->load('init.local_info.ip');
        $context = stream_context_create([
            'ssl' => [
                'local_cert'        => '/root/crt/server.pem',
                'capath'            => '/root/crt/clients/',
                'allow_self_signed' => FALSE,
                'verify_peer'       => TRUE,
                'capture_peer_cert' => TRUE, // peer_certificate
            ]
        ]);

        $socket = stream_socket_server(
            $this->transport.'://'.$ip.':'.$this->port,
            $errno,
            $errstr,
            STREAM_SERVER_BIND|STREAM_SERVER_LISTEN,
            $context
        );

        if (!$socket) {
            Minion_CLI::write($errstr, $errno);
        } else {
            while (1) {
                try{
                    $conn = stream_socket_accept($socket, -1);

                    $data = json_decode(
                        fread($conn, 1024),
                        true
                    );

                    switch ($data['method']) {
                        case 'info':
                            $logs = $this->getLogs(
                                $data['client_id'],
                                $data['tor']
                            );
                            fwrite($conn, $logs);
                            break;
                        case 'online':
                            fwrite($conn, "In progress...\n");
                            break;
                    }

                    fclose($conn);
                }catch (Exception $e){
                    Minion_CLI::write($e->getMessage());
                }

            }
            fclose($socket); // Rly ?? :))
        }
    }



    private function getLogs($client_id, $tor){
        $array = array();
        $client = Task_Helper::getClient();
        $client->setCompleteCallback(function($task) use(&$array){
            if($data = $task->data()){
                $array[] = json_decode($data, true);
            }
        });
        $client->addTask('Search::Logpost', json_encode([
            'client' => $client_id,
            'tor' => $tor
        ]));
        $client->runTasks();

        $result = array();
        foreach($array as $k1 => $a){
            foreach($a['data'] as $k2 => $d){
                if($tor) {
                    $transport = 'http://';
                }else{
                    $transport = 'https://';
                }

                $result[] = $transport.$a['server'].'/logpost/more/'.$d['id'];
            }
        }

        return json_encode($result);
    }
}